#! /usr/bin/python2.7
"""	changelog
2015-09-28: PlotLRBargraph, PlotLRBargraphInit: Vereinfachter einfarbiger Pegelbalken. Erfordert Nacharbeiten in allen levelmetern.
Die beiden PlotKanaelen gemeinsamen limit1, limit2 werden ersetzt durch die getrennten Sessionparameter gainleft, gainright.
Diese werden im Hauptprogramm global hinzuaddiert zu den Pegeln links/rechts, erscheinen also sowohl auf dem Bildschirm als auch in den log-Dateien.

"""
import pyaudio
import time
import sys
import numpy as np
from scipy.signal import butter, lfilter, freqz
from math import sqrt
import matplotlib.pyplot as plt
import wave
#from scipy.fftpack import fft2
p = pyaudio.PyAudio()

#   Debugging Ausgaben

def ArrayInfo(AnyArray):
    print "type      %s"%type(AnyArray)
    print "dimension %d"%AnyArray.ndim
    print "size      %d"%AnyArray.size
    print AnyArray.shape
    print "data type %s"%AnyArray.dtype.name
    print "item size %d"%AnyArray.itemsize

def ProfilerStart():
    starttime = time.time()
    return(starttime)

def ProfilerStop(starttime, maxtime):
    elapsed = time.time() - starttime
    if elapsed > maxtime:
       maxtime = elapsed 
       print "Rechenzeit  %f sec"%maxtime
    return maxtime

#   Datei-Operationen

def FileInit(filename, text, separator):
    filevar = open(filename, 'a')
    filevar.write(text + separator)
    filevar.flush()
    return filevar

def FileAppend(filevar, text, separator):
    filevar.write(text + separator)
    filevar.flush()

#   n-Sekunden-Ticker

def NSecTickerInit():
    StartTime = time.time()
    return StartTime

def NSecTicker(nsec, starttime,  remainder, newtic):
    acttime = time.time() - starttime
    actremainder = acttime % nsec
    if actremainder < remainder: 
        # handshake-flag, wird vom Hauptprogramm geloescht
        newtic = True
    return(newtic, actremainder)

#   Soundkarte

def GetDefaultInputDevice():
    CardId = p.get_default_input_device_info()["index"] 
    return CardId

#   Butterworth Bandpassfilter

def GetBpCoefficients(fs, lowcut, highcut, order):
    nyq = 0.5 * fs
    low = lowcut / nyq
    high = highcut / nyq
    b, a = butter(order, [low, high], btype='band')
    return b, a

def StereoBpFilter(data, b, a):
    dataL = data[ : ,0]
    dataL = lfilter(b, a, dataL)
    dataR = data[ : ,1]
    dataR = lfilter(b, a, dataR)
    return dataL, dataR

def NoFilter(data, b, a):
    dataL = data[ : ,0]
    dataR = data[ : ,1]
    return dataL, dataR

#   FFT

def FFTfilter(Data):
    nFFT = 512 
    y_L = Data[ : ,0]   
    y_R = Data[ : ,1]
    Y_L = np.fft.fft(y_L, nFFT)
    Y_R = np.fft.fft(y_R, nFFT)
    # Sewing FFT of two channels together, DC part uses right channel's
    Data = abs(np.hstack((Y_L[-nFFT/2:-1], Y_R[:nFFT/2])))
    return Data

#   Audio-Datenbloecke, "multi-chunk" Puffer

def Chunk2FloatArray(data, framecount, chunkbuffers, channels):
    # raw data string of integers) -> (1-dim array)
    data = np.fromstring(data, dtype=np.int16)
    # int16 -> float32
    data = data.astype(np.float32)
    # Pegel normieren auf  +/-1.0 F.S.
    data = data/2**15 #!!!
    # 1 stereo array -> L/R array
    data = np.reshape(data, (framecount*chunkbuffers, channels))
    return(data)

#   Messwerte, gemittelt ueber jeweils einen multi-chunk Puffer

def MonoLevelMeter(AudioChannel, maxholdtmp):
    level = abs(AudioChannel)
    peak = level[np.argmax(level)]
    peak = 20 * np.log10(peak)
    avg = np.average(level)
    avg = 20 * np.log10(avg)
    rms = np.square(AudioChannel)
    rms = np.sum(rms)
    rms = sqrt(rms)/110             #bug!!!
    rms = 20 * np.log10(rms)
    # max hold wird doppelt gepuffert
    if rms > maxholdtmp:
        maxholdtmp = rms
    return(rms, maxholdtmp)

def MonoRmsMeter(AudioChannel, maxholdtmp):
    rms = np.square(AudioChannel)
    rms = np.sum(rms)
    rms = sqrt(rms)/110             #bug!!!
    rms = 20 * np.log10(rms)
    # max hold wird doppelt gepuffert
    if rms > maxholdtmp:
        maxholdtmp = rms
    return(rms, maxholdtmp)

def StereoRmsMeter(dataL, dataR, maxholdLtmp, maxholdRtmp):
    rmsL, maxholdLtmp = MonoRmsMeter(dataL, maxholdLtmp)
    rmsR, maxholdRtmp = MonoRmsMeter(dataR, maxholdRtmp)
    return(rmsL, rmsR, maxholdLtmp, maxholdRtmp)

#   Messwertaufbereitung fuer 3-Bereichs-Balkenanzeige

def SplitMonoLevel(level, limit1, limit2):
    # split level into toplevel, (med+bot)level 
    level = level / limit2
    toplevel, midlevel = np.modf(level)
    toplevel = toplevel * limit2
    midlevel = midlevel * limit2
    if midlevel==0:
        midlevel = toplevel
        toplevel = 0
    # split (med+bot)level into medlevel, botlevel
    midlevel = midlevel / limit1
    midlevel, botlevel = np.modf(midlevel)
    midlevel = midlevel * limit1
    botlevel = botlevel * limit1
    if botlevel==0:
        botlevel = midlevel
        midlevel = 0
    return(toplevel, midlevel, botlevel)

#   3-Bereichs-Stereo-Balkenanzeige + peak-hold

def PlotLRBargraph3Init(rmsL, rmsR, xmin, xmax, ymin, ymax, limit1, limit2, title):
    fig = plt.figure()
    level = rmsL-ymin, rmsL-ymin
    rectpk = plt.bar(range(2), (2,2), bottom = (0,0), align = 'center', color = 'k')
    rectbot = plt.bar(range(2), level, bottom = ymin, align = 'center', color = 'g')
    rectmid = plt.bar(range(2), level, bottom = limit1, align = 'center', color = 'y')
    recttop = plt.bar(range(2), level, bottom = limit2, align = 'center', color = 'r')
    plt.axis([xmin, xmax, ymin, ymax])
    plt.ylabel("rms, dB FS")
    plt.title(title)
    plt.show(block=False)
    return(rectbot, rectmid, recttop, rectpk, fig)

def PlotLRBargraph3(leftlevel,rightlevel,leftpkhold,rightpkhold,ymin,rectbot,rectmid,recttop,rectpk,fig,limit1,limit2):
    # -100..0 -> 0..100
    limit1 = limit1 - ymin
    limit2 = limit2 - ymin
    leftlevel = leftlevel - ymin 
    rightlevel = rightlevel - ymin 
    lefttop, leftmid, leftbot = SplitMonoLevel(leftlevel, limit1, limit2)
    righttop, rightmid, rightbot = SplitMonoLevel(rightlevel, limit1, limit2)
    bot = (leftbot, rightbot)
    mid = (leftmid, rightmid)
    top = (lefttop, righttop)
    pk  = (leftpkhold, rightpkhold)
    for rect, h in zip(rectpk, pk):
        rect.set_height(h)
    for rect, h in zip(rectbot, bot):
        rect.set_height(h)
    for rect, h in zip(rectmid, mid):
        rect.set_height(h)
    for rect, h in zip(recttop, top):
        rect.set_height(h)
    fig.canvas.draw()

#   Stereo-Balkenanzeige + peak-hold

def PlotLRBargraphInit(xmin, xmax, ymin, ymax, title):
    fig = plt.figure()
    level = 0, 0	
    rectpk = plt.bar(range(2), (2,2), bottom = (0,0), align = 'center', color = 'r')
    rectbot = plt.bar(range(2), level, bottom = ymin, align = 'center', color = 'g')
    plt.axis([xmin, xmax, ymin, ymax])
    plt.ylabel("rms, dB FS")
    plt.title(title)
    plt.show(block=False)
    return(rectbot, rectpk, fig)

def PlotLRBargraph(leftlevel,rightlevel,leftpkhold,rightpkhold,ymin,rectbot,rectpk,fig):
    # -100..0 -> 0..100
    leftlevel = leftlevel - ymin 
    rightlevel = rightlevel - ymin 
    bot = (leftlevel, rightlevel)
    pk  = (leftpkhold, rightpkhold)
    for rect, h in zip(rectbot, bot):
        rect.set_height(h)
    for rect, h in zip(rectpk, pk):
        rect.set_height(h)
    fig.canvas.draw()

#   Anzeige Kurvenverlauf

def FirstPlot1Line(PlotData, xmin, xmax, ymin, ymax, limit1):
    x = np.linspace(xmin, xmax, PlotData.size)
    yl = PlotData
    fig, ax = plt.subplots()
    #ax.grid = True
    plt.hlines(limit1, xmin, xmax, color = 'red', linestyles = 'dashed')
    #override autoscale
    plt.axis([xmin, xmax, ymin, ymax])
    plt.ylabel("rms, dB FS")
    plt.title("Stereo FFT-Analyse")
    #plt.grid = True
    line1, = ax.plot(x, yl, 'r-') 
    plt.show(block=False)
    line1.set_ydata(yl)
    ax.draw_artist(ax.patch)
    ax.draw_artist(line1)
    fig.canvas.draw()
    fig.canvas.flush_events()
    return(line1, ax, fig)

def Plot1Line(PlotData, line1, ax, fig, xmin, xmax):
    x = np.linspace(xmin, xmax, PlotData.size)
    yl = PlotData
    line1.set_ydata(yl)
    ax.draw_artist(ax.patch)
    ax.draw_artist(line1)
    fig.canvas.draw()
    fig.canvas.flush_events()

# Sinus Dauertonerzeugung - den doppelten Chunkbuffer mit Sinusschwingungen fuellen

def xDDS_Init(fq, level, samplerate, chunklen):
    # wird auch zur PhasenSprungKorrektur benoetigt
    maxphase = 2 * np.pi * fq * 2 * chunklen / samplerate
    x = np.linspace(0, maxphase, 2 * chunklen)
    dualchunkbuf = level*2**15*np.sin(np.array(x))  #*level
    dualchunkbuf = dualchunkbuf.astype(np.int16) 
    return(dualchunkbuf,maxphase)



# Sinus Dauertonerzeugung - den doppelten Chunkbuffer mit Sinusschwingungen fuellen

def DDS_Init(fq, level, samplerate, chunklen):
    maxphase = 2 * np.pi * fq * chunklen / samplerate
    x = np.linspace(0, maxphase, 2 * chunklen)
    dualchunkbuf = level*2**15*np.sin(np.array(x))  
    dualchunkbuf = dualchunkbuf.astype(np.int16)
    phaseofs = maxphase % (2 * np.pi)
    phaseofs = -phaseofs
    return(dualchunkbuf,maxphase,phaseofs)

def DoubleChunkInit(fq, level, samplerate, chunklen):
    maxphase = 2 * np.pi * fq * chunklen / samplerate
#    phaseofs = maxphase % (2 * np.pi)
    phaseofs = np.fmod(maxphase,(2 * np.pi))
    x = np.arange (2*chunklen)    #!!!
    doublechunkbuf = np.array(x)
#    xcoeff = ((chunklen+1.0)/chunklen) * 2 * np.pi * fq / samplerate
    xcoeff = 2 * np.pi * fq / samplerate
    doublechunkbuf = level*2**15*np.sin(x * xcoeff)
    doublechunkbuf = doublechunkbuf.astype(np.int16)
    print "MaxPhase=%f PhaseOfs=%f"%(maxphase,phaseofs)
    return(doublechunkbuf,phaseofs,maxphase)

