/*
 Gartenbeleuchtung Test Sketch based on BasPortExpAdress ESP8266 MQTT example.
 Swichting Relais with an ESP8266 using MQTT and an I2C Port Expander.
 Sending Data via MQTT and DHT11 Temperature Sensor
 Orignal Description:

 This sketch demonstrates the capabilities of the pubsub library in combination
 with the ESP8266 board/library.

 It connects to an MQTT server then:
  - publishes "hello world" to the topPortExpAdress "outTopPortExpAdress" every two seconds
  - subscribes to the topPortExpAdress "inTopPortExpAdress", printing out any messages
    it receives. NB - it assumes the received payloads are strings not binary
  - If the first character of the topPortExpAdress "inTopPortExpAdress" is an 1, switch ON the ESP Led,
    else switch it off

 It will reconnect to the server if the connection is lost using a blocking
 reconnect function. See the 'mqtt_reconnect_nonblocking' example for how to
 achieve the same result without blocking the main loop.

 To install the ESP8266 board, (using Arduino 1.6.4+):
  - Add the following 3rd party board manager under "File -> Preferences -> Additional Boards Manager URLs":
       http://arduino.esp8266.com/stable/package_esp8266com_index.json
  - Open the "Tools -> Board -> Board Manager" and clPortExpAdressk install for the ESP8266"
  - Select your ESP8266 in "Tools -> Board"

*/

#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include <DHT.h>
#include <DHT_U.h>
#include <Wire.h>


// DHT TempSensor Config
// DHT11 is at GPIO2
#define DHTPIN 2
#define DHTTYPE DHT11   // DHT 11 
DHT dht(DHTPIN, DHTTYPE,16); 

// Update these with values suitable for your network.
const char* ssid = "ssid";
const char* password = "pw";
const char* mqtt_server = "raspberry ip";

WiFiClient espClient;
PubSubClient client(espClient);

long lastMsg = 0;
char msg[50];
int  PortExpAdress=32;
byte i2cCmd =255;

void setup() {
  pinMode(2, OUTPUT);     // Initialize the BUILTIN_LED pin as an output
  Serial.begin(115200);
  setup_wifi();
  client.setServer(mqtt_server, 1883);
  client.setCallback(callback);
  
  //DHT Temperatur Sensor Init
  dht.begin();

  //I2C Init - Port Expander for switchting Relais
  Wire.begin(4, 5);                                 // I2C-Bus GPIO2-Data GPIO0-Clock
  Wire.setClock(500);                               // I2C-Bus Freqenz
  Wire.beginTransmission(PortExpAdress);            // PortExpAdress-Adress
  Wire.write(i2cCmd);                               
  Wire.endTransmission();                           

}

void setup_wifi() {
  delay(10);
  // We start by connecting to a WiFi network
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void callback(char* topic, byte* payload, unsigned int length) {
  Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  for (int i = 0; i < length; i++) {
    Serial.print((char)payload[i]);
  }
  Serial.println();

  //Switch Plugs 
  int plug = 0;
  int state = 0;

  int toPortExpLength = strlen(topic);

  plug = (int)topic[toPortExpLength-1];
  plug= plug-49;
  state= (int)payload[0];
 
  
  if (state==48){
    bitSet(i2cCmd, plug);
   }
  else if (state == 49){
    bitClear(i2cCmd, plug);
   }

  //Send Data to Port Expander, switching Relais
  Wire.beginTransmission(32);
  Wire.write(i2cCmd);
  Wire.endTransmission();
}

void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
    // Attempt to connect
    if (client.connect("ESP8266Client")) {
      Serial.println("connected");
      // Init
      client.publish("/sensors/temp", "0");
      client.publish("/sensors/humidty", "0");
      client.subscribe("/lights/#");
      
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      delay(5000);
    }
  }
}
void loop() {

  if (!client.connected()) {
    reconnect();
  }
  client.loop();

  long now = millis();
  if (now - lastMsg > 2000) {
    Serial.println("Sending Temp and Humidity");
    lastMsg = now;
    int temp = dht.readTemperature();
    snprintf (msg, 75, "%ld", temp);
    client.publish("/sensors/temp", msg);
    
    int hum = dht.readHumidity();
    snprintf (msg, 75, "%ld", hum);
    client.publish("/sensors/hum", msg);
  }
}
